/*--------------------------------------------------------------------------*\

    FILE....: MT.CPP
    TYPE....: C++ Program
    AUTHOR..: David Rowe
    DATE....: 6/9/01

    Test program for Voicetronix VPB4 (ISA), VPB8L (ISA), V4PCI (PCI) cards.  
    This program can be used as a basic hardware test program, and is useful 
    for determining if the I/O base address is set correctly (ISA cards).
    
    Can be used under Linux or NT.  See README on how to set card type.
    
    Note: Requires the kernel mode driver to be installed.
    
\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "../src/generic.h"
#include "../src/hip.h"
#include "../src/vpbreg.h"

#define SIZE_WD   0xffff
#define MAX_FAILS 10

int main(int argc, char *argv[]) {
	int               i;
	unsigned short    bufwr[SIZE_WD];
	unsigned short    bufrd[SIZE_WD];
	int               base;		    // ISA base addr or PCI board num
	int               fails = 0;
	int               length = SIZE_WD;

	if (argc < 2) {
		printf("usage: mt BASE [length]\n");
		printf("e.g. for ISA 'mt 0x300' or 'mt 0x310 0xffff'\n");
		printf("e.g. for PCI 'mt 0' or 'mt 1 0xffff'\n");
		exit(0);
	}

	// init
	sscanf(argv[1], "%x", &base);
	if (argc == 3)
		sscanf(argv[2], "%x", &length);
	assert((length > 0) && (length <= SIZE_WD));

	// work out which device driver we are using
	unsigned short numvpb;
	VPBRegister v = VPBRegister(&numvpb);
	VPBREG *vr = v.reg;

	// OK, init host interface port (HIP)
	Hip h = Hip(vr->ddmodel);

	// set up write block
	for(i=0; i<length; i++)
		bufwr[i] = i;

	// Place DSP in reset
	h.InitVpb(base);
	h.DspReset(0);
	
	// block write to DSP RAM
	h.WriteDspSram(0, 0x0, length, bufwr);

	// block read from DSP RAM
	h.ReadDspSram(0, 0x0, length, bufrd);

	// check read block is the same as write block
	for(i=0; i<length; i++) {
		if (bufwr[i] != bufrd[i]) {
			printf("Error [0x%04x] wr = 0x%04x rd = 0x%04x\n",
			       i, bufwr[i], bufrd[i]);
			fails++;
			if (fails == MAX_FAILS) {
				printf("FAILED!\n");
				exit(1);
			}
		}
	}

	if (fails)
		printf("FAILED!\n");
	else
		printf("PASSED!\n");
	
	return 0;
}
